#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <climits>

using namespace std;

struct Point {
    int x, y;

    Point(int x = 0, int y = 0) : x(x), y(y) {}

    bool operator<(const Point& p) const { 
        return x < p.x || (x == p.x && y < p.y);
    }
    bool operator==(const Point& p) const { 
        return x == p.x && y == p.y;
    }
};

long long clockOrientation(const Point& p1, const Point& p2, const Point& p3) {
    return 1LL * (p2.x - p1.x) * (p3.y - p1.y) - 1LL * (p2.y - p1.y) * (p3.x - p1.x);
}

vector<Point> convexHull(vector<Point>& points, Point& target) {
    sort(points.begin(), points.end());

    vector<Point> lower;
    for (const Point& p : points) { 
        if (p == target) continue; 
        while (lower.size() >= 2 && clockOrientation(lower[lower.size() - 2], lower[lower.size() - 1], p) <= 0) {
            lower.pop_back();
        }
        lower.push_back(p);
    }

    vector<Point> upper;
    for (int i = points.size() - 1; i >= 0; i--) { 
        if (points[i] == target) continue; 
        while (upper.size() >= 2 && clockOrientation(upper[upper.size() - 2], upper[upper.size() - 1], points[i]) <= 0) {
            upper.pop_back();
        }
        upper.push_back(points[i]);
    }

    lower.pop_back();
    upper.pop_back();

    lower.insert(lower.end(), upper.begin(), upper.end());

    return lower;
}

long long shoelaceArea(vector<Point>& hull) {
    long long area = 0;
    int n = hull.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        area += 1LL * hull[i].x * hull[j].y;
        area -= 1LL * hull[i].y * hull[j].x;
    }
    area = abs(area);
    return area; 
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    cin >> N;
    vector<Point> points(N);

    for (int i = 0; i < N; i++) {
        cin >> points[i].x >> points[i].y;
    }


    long long minArea = LLONG_MAX;
    for (int i = 0; i < N; i++) {
        vector<Point> hull = convexHull(points, points[i]);
        minArea = min(minArea, shoelaceArea(hull));
    }

    cout << minArea / 2;
    return 0;
}